'use strict';
/**
 * Smart block version 3.0
 * スマートブロック
 * クリックすると、直後のブロックがスライドダウンして現れる
 * (CC BY+SA 4.0) クリエイティブコモンズ 表示+継承 2023 有限会社デジタルエイド
 * https://www.digital-aid.co.jp/tool/smart-block/
 */

const ddBlocks = document.querySelectorAll('dl.smart-block dd');
for ( let ddBlock of ddBlocks ) {
  let dHeight = ddBlock.offsetHeight;
  ddBlock.setAttribute('data-height', dHeight);
  ddBlock.classList.add('h0');
}

const dtBlocks = document.querySelectorAll('dl.smart-block dt');
let pBlock;
for ( let dtBlock of dtBlocks ) {
  dtBlock.addEventListener('click', function( event ) {
    let tBlock = this.nextElementSibling;
    let tHeight = tBlock.getAttribute('data-height');
    tBlock.style.setProperty('--t-height', `${ tHeight }px`);
    if ( tBlock.closest('dl').classList.contains('open') ) {
      if ( !tBlock.classList.contains('slide-down')) {
        tBlock.classList.add('slide-down');
        tBlock.classList.remove('h0', 'slide-up');
      } else {
        tBlock.classList.replace('slide-down', 'slide-up');
      }
    } else {
      if ( !tBlock.classList.contains('slide-down') ) {
        tBlock.classList.add('slide-down');
        tBlock.classList.remove('h0', 'slide-up');
      }
      if ( pBlock ) {
        let pHeight = pBlock.getAttribute('data-height');
        pBlock.style.setProperty('--t-height', `${ pHeight }px`);
        pBlock.classList.replace('slide-down', 'slide-up' );
        pBlock.previousElementSibling.classList.remove('current');
      }
    }
    event.target.classList.add('current');
    pBlock = tBlock;
  });
}
